#!/bin/sh
PLUGIN=IntegrateFX
cd "$(dirname "$0")"
set -eu

# $1 is the home directory
# $2 is whether the CLAP format should be installed
# $3 is whether the AU format should be installed
# $4 is whether the Standalone format should be installed
# $5 is whether the FL format should be installed
# $6 is the name of the user
# $7 is the FL path

SKIP_ANY=0

if [ "$2" -eq 1 ]; then
	SKIP=0

	if [ -f "$1"/Library/Audio/Plug-Ins/CLAP/$PLUGIN.clap/Contents/Info.plist ]; then
		if grep nakst < "$1"/Library/Audio/Plug-Ins/CLAP/$PLUGIN.clap/Contents/Info.plist > /dev/null; then
			rm -r "$1"/Library/Audio/Plug-Ins/CLAP/$PLUGIN.clap/
		else
			SKIP=1
			SKIP_ANY=1
		fi
	fi

	if [ "$SKIP" -eq 0 ]; then
		cp -r clap.dat /tmp/8d9e53d0542acff4.dat
		/usr/bin/xattr -r -d com.apple.quarantine /tmp/8d9e53d0542acff4.dat
		mv /tmp/8d9e53d0542acff4.dat "$1"/Library/Audio/Plug-Ins/CLAP/$PLUGIN.clap
		mkdir -p "$1"/Library/Audio/Plug-Ins/CLAP/$PLUGIN.clap/Contents/Resources
		cp respack.dat "$1"/Library/Audio/Plug-Ins/CLAP/$PLUGIN.clap/Contents/Resources/respack.dat
		chown -R "$6" "$1"/Library/Audio/Plug-Ins/CLAP/$PLUGIN.clap
	fi
fi

if [ "$3" -eq 1 ]; then
	SKIP=0

	if [ -f "$1"/Library/Audio/Plug-Ins/Components/$PLUGIN.component/Contents/Info.plist ]; then
		if grep nakst < "$1"/Library/Audio/Plug-Ins/Components/$PLUGIN.component/Contents/Info.plist > /dev/null; then
			rm -r "$1"/Library/Audio/Plug-Ins/Components/$PLUGIN.component/
		else
			SKIP=1
			SKIP_ANY=1
		fi
	fi

	if [ "$SKIP" -eq 0 ]; then
		cp -r au.dat /tmp/8d9e53d0542acff4.dat
		/usr/bin/xattr -r -d com.apple.quarantine /tmp/8d9e53d0542acff4.dat
		mv /tmp/8d9e53d0542acff4.dat "$1"/Library/Audio/Plug-Ins/Components/$PLUGIN.component
		mkdir -p "$1"/Library/Audio/Plug-Ins/Components/$PLUGIN.component/Contents/Resources
		cp respack.dat "$1"/Library/Audio/Plug-Ins/Components/$PLUGIN.component/Contents/Resources/respack.dat
		chown -R "$6" "$1"/Library/Audio/Plug-Ins/Components/$PLUGIN.component
		killall -9 AudioComponentRegistrar
	fi
fi

if [ "$4" -eq 1 ]; then
	SKIP=0

	if [ -f /Applications/$PLUGIN.app/Contents/Info.plist ]; then
		if grep nakst < /Applications/$PLUGIN.app/Contents/Info.plist > /dev/null; then
			rm -r /Applications/$PLUGIN.app/
		else
			SKIP=1
			SKIP_ANY=1
		fi
	fi

	if [ "$SKIP" -eq 0 ]; then
		cp -r standalone.dat /Applications/$PLUGIN.app
		/usr/bin/xattr -r -d com.apple.quarantine /Applications/$PLUGIN.app
		mkdir -p /Applications/$PLUGIN.app/Contents/Resources
		cp respack.dat /Applications/$PLUGIN.app/Contents/Resources/respack.dat
	fi
fi

if [ "$5" -eq 1 ]; then
	SKIP=0

	if [ -f "$7"/Contents/Resources/FL/Plugins/Fruity/Generators/$PLUGIN/Contents/Info.plist ]; then
		if grep nakst < "$7"/Contents/Resources/FL/Plugins/Fruity/Generators/$PLUGIN/Contents/Info.plist > /dev/null; then
			rm -r "$7"/Contents/Resources/FL/Plugins/Fruity/Generators/$PLUGIN/
		else
			SKIP=1
			SKIP_ANY=1
		fi
	fi

	if [ "$SKIP" -eq 0 ]; then
		mkdir -p "$7"/Contents/Resources/FL/Plugins/Fruity/Generators/$PLUGIN/Contents/Resources
		cp fl.dat "$7"/Contents/Resources/FL/Plugins/Fruity/Generators/$PLUGIN/`echo $PLUGIN`_x64.dylib
		cp respack.dat "$7"/Contents/Resources/FL/Plugins/Fruity/Generators/$PLUGIN/Contents/Resources/respack.dat
		/usr/bin/xattr -r -d com.apple.quarantine "$7"/Contents/Resources/FL/Plugins/Fruity/Generators/$PLUGIN/
	fi
fi

if [ "$SKIP_ANY" -eq 1 ]; then
	echo Some formats were not installed as there were existing files in the destination.
	exit 1
fi
